/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapping.tile.wall;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import technology.rocketjump.undermount.mapping.tile.CompassDirection;
import technology.rocketjump.undermount.mapping.tile.wall.Edge;

public class WallEdgeDefinition {
    public static final float INNER_EDGE_X1 = 0.3125f;
    public static final float INNER_EDGE_X2 = 0.671875f;
    public static final float INNER_EDGE_Y1 = 0.59375f;
    public static final float INNER_EDGE_Y2 = 0.96875f;
    private final Array<Edge> inner;
    private final Array<Edge> outer;

    public WallEdgeDefinition(Array<Edge> inner, Array<Edge> outer) {
        this.inner = inner;
        this.outer = outer;
    }

    public WallEdgeDefinition flipX() {
        Array<Edge> flippedInner = new Array<Edge>(this.inner.size);
        for (Edge originalInnerEdge : this.inner) {
            Vector2 flippedPointA = new Vector2(this.flipXPoint(originalInnerEdge.getPointA().x), originalInnerEdge.getPointA().y);
            Vector2 flippedPointB = new Vector2(this.flipXPoint(originalInnerEdge.getPointB().x), originalInnerEdge.getPointB().y);
            flippedInner.add(new Edge(flippedPointA, flippedPointB));
        }
        Array<Edge> flippedOuter = new Array<Edge>(this.outer.size);
        for (Edge originalOuterEdge : this.outer) {
            Vector2 flippedPointA = new Vector2(this.flipXPoint(originalOuterEdge.getPointA().x), originalOuterEdge.getPointA().y);
            Vector2 flippedPointB = new Vector2(this.flipXPoint(originalOuterEdge.getPointB().x), originalOuterEdge.getPointB().y);
            flippedOuter.add(new Edge(flippedPointA, flippedPointB));
        }
        return new WallEdgeDefinition(flippedInner, flippedOuter);
    }

    public Array<Edge> getEdgesForVisibilityPolygon(Vector2 sourcePoint) {
        CompassDirection wallDirection;
        Array<Edge> results = new Array<Edge>(this.inner.size + this.outer.size);
        for (Edge innerEdge : this.inner) {
            wallDirection = innerEdge.getDirection();
            if (wallDirection.equals((Object)CompassDirection.NORTH)) {
                if (!(innerEdge.getPointA().x > sourcePoint.x)) continue;
                results.add(innerEdge);
                continue;
            }
            if (wallDirection.equals((Object)CompassDirection.SOUTH)) {
                if (!(innerEdge.getPointA().x < sourcePoint.x)) continue;
                results.add(innerEdge);
                continue;
            }
            if (wallDirection.equals((Object)CompassDirection.EAST)) {
                if (!(innerEdge.getPointA().y < sourcePoint.y)) continue;
                results.add(innerEdge);
                continue;
            }
            if (!wallDirection.equals((Object)CompassDirection.WEST) || !(innerEdge.getPointA().y > sourcePoint.y)) continue;
            results.add(innerEdge);
        }
        for (Edge outerEdge : this.outer) {
            wallDirection = outerEdge.getDirection();
            if (wallDirection.equals((Object)CompassDirection.NORTH)) {
                if (!(outerEdge.getPointA().x < sourcePoint.x)) continue;
                results.add(outerEdge);
                continue;
            }
            if (wallDirection.equals((Object)CompassDirection.SOUTH)) {
                if (!(outerEdge.getPointA().x > sourcePoint.x)) continue;
                results.add(outerEdge);
                continue;
            }
            if (wallDirection.equals((Object)CompassDirection.EAST)) {
                if (!(outerEdge.getPointA().y > sourcePoint.y)) continue;
                results.add(outerEdge);
                continue;
            }
            if (!wallDirection.equals((Object)CompassDirection.WEST) || !(outerEdge.getPointA().y < sourcePoint.y)) continue;
            results.add(outerEdge);
        }
        return results;
    }

    public Array<Edge> getInnerEdges() {
        return this.inner;
    }

    public Array<Edge> getOuterEdges() {
        return this.outer;
    }

    private float flipXPoint(float x) {
        if (x == 1.0f) {
            return 0.0f;
        }
        if (x == 0.0f) {
            return 1.0f;
        }
        if (x == 0.3125f) {
            return 0.671875f;
        }
        if (x == 0.671875f) {
            return 0.3125f;
        }
        throw new IllegalArgumentException("Unrecognised x co-ordinate to flip for WallEdgeDefinition: " + x);
    }
}

